// Enum Definitions
export enum AlatStatus {
  TERSEDIA = 'Tersedia',
  DIPINJAM = 'Dipinjam',
  RUSAK = 'Rusak',
  MAINTENANCE = 'Maintenance'
}

export enum PeminjamanStatus {
  DIPINJAM = 'Sedang Dipinjam',
  DIKEMBALIKAN = 'Dikembalikan'
}

// Database Interfaces
export interface Lab {
  id: string;
  nama_lab: string;
}

export interface Reagen {
  id: string;
  lab_id: string;
  nama_reagen: string;
  brand: string;
  katalog_no: string;
}

export interface StokReagenLot {
  id: string;
  reagen_id: string;
  no_lot: string;
  tgl_expired: string; // ISO Date String
  stok_sekarang: number;
  satuan: string;
}

export interface LogPemakaianReagen {
  id: string;
  lot_id: string;
  jumlah_digunakan: number;
  tgl_input: string; // ISO Date String
  keterangan: string;
  // Joined fields for UI convenience
  nama_reagen?: string;
  no_lot?: string;
}

export interface Alat {
  id: string;
  lab_id: string;
  nama_alat: string;
  merk: string;
  tipe: string;
  status: AlatStatus;
}

export interface PeminjamanAlat {
  id: string;
  alat_id: string;
  peminjam: string;
  tgl_pinjam: string;
  tgl_kembali?: string;
  status_kembali: PeminjamanStatus;
  // Joined fields
  nama_alat?: string;
}

export interface KalibrasiAlat {
  id: string;
  alat_id: string;
  tgl_kalibrasi: string;
  tgl_expired_kalibrasi: string;
  file_sertifikat_url?: string;
  // Joined fields
  nama_alat?: string;
}

// Stats Interface
export interface DashboardStats {
  totalReagents: number;
  lowStockCount: number;
  expiringReagentsCount: number;
  calibrationDueCount: number;
  totalTools: number;
  activeLoans: number;
}